<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Service
 *
 * @ORM\Table(name="services")
 * @ORM\Entity
 */
class Service
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="ip", type="string", length=15, nullable=true)
     */
    private $ip;

    /**
     * @var string
     *
     * @ORM\Column(name="app_key", type="string", length=255, unique=true)
     */
    private $appKey;

    /**
     * @ORM\ManyToMany(targetEntity="Method", mappedBy="services")
     * @ORM\JoinTable(name="service_methods")
     */
    protected $methods;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Service
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set ip
     *
     * @param string $ip
     * @return Service
     */
    public function setIp($ip)
    {
        $this->ip = $ip;
    
        return $this;
    }

    /**
     * Get ip
     *
     * @return string 
     */
    public function getIp()
    {
        return $this->ip;
    }

    /**
     * Set appKey
     *
     * @param string $appKey
     * @return Service
     */
    public function setAppKey($appKey)
    {
        $this->appKey = $appKey;
    
        return $this;
    }

    /**
     * Get appKey
     *
     * @return string 
     */
    public function getAppKey()
    {
        return $this->appKey;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->methods = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add methods
     *
     * @param \VM\ApiBundle\Entity\Method $methods
     * @return Service
     */
    public function addMethod(\VM\ApiBundle\Entity\Method $methods)
    {
        $this->methods[] = $methods;
    
        return $this;
    }

    /**
     * Remove methods
     *
     * @param \VM\ApiBundle\Entity\Method $methods
     */
    public function removeMethod(\VM\ApiBundle\Entity\Method $methods)
    {
        $this->methods->removeElement($methods);
    }

    /**
     * Get methods
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getMethods()
    {
        return $this->methods;
    }
}